/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.CompoundIndexHookIterator;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

abstract class FluidModifierHookIterator<I>
extends CompoundIndexHookIterator<ToolFluidCapability.FluidModifierHook, I> {
    protected ModifierEntry indexEntry = null;

    FluidModifierHookIterator() {
    }

    @Override
    protected int getSize(IToolStackView tool, ToolFluidCapability.FluidModifierHook hook) {
        return hook.getTanks(tool, this.indexEntry.getModifier());
    }

    protected long fill(ContainerItemContext context, IToolStackView tool, FluidVariant resource, long maxAmount, TransactionContext tx) {
        int totalFilled = 0;
        Iterator iterator = this.getIterator(tool);
        while (iterator.hasNext()) {
            long filled = ((ToolFluidCapability.FluidModifierHook)this.getHook(iterator.next())).fill(context, tool, this.indexEntry, resource, maxAmount, tx);
            if (filled <= 0L) continue;
            if (filled >= maxAmount) {
                return (long)totalFilled + filled;
            }
            totalFilled = (int)((long)totalFilled + filled);
            maxAmount -= filled;
        }
        return totalFilled;
    }

    public long drain(ContainerItemContext context, IToolStackView tool, FluidVariant resource, long maxAmount, TransactionContext tx) {
        long drainedSoFar = 0L;
        Iterator iterator = this.getIterator(tool);
        while (iterator.hasNext()) {
            long drained = ((ToolFluidCapability.FluidModifierHook)this.getHook(iterator.next())).drain(context, tool, this.indexEntry, resource, maxAmount, tx);
            if (drained == 0L) continue;
            if (drainedSoFar <= 0L) {
                if (drained >= maxAmount) {
                    return drained;
                }
                drainedSoFar = drained;
            } else {
                drainedSoFar += drained;
            }
            if ((maxAmount -= drained) > 0L) continue;
            return drainedSoFar;
        }
        return drainedSoFar;
    }
}

